define(['angular', 'app'], function (angular, app) {
	"use strict";

	app.factory('httpInterceptor', function ($q, $injector) {
		var interceptor = {};

		interceptor.responseError = function (rejection) {
			var newPromise;
			switch (rejection.status) {
				case 400:
					break;
				case 401:
					$injector.invoke(['authenticationService', 'connectionTimeoutService', function (authenticationService, connectionTimeoutService) {
						if (authenticationService.isAuthenticated()) {
							connectionTimeoutService.showSessionEndedMsg();
						}
					}]);
					break;
				default:
					if(rejection.status >= 100){
						newPromise = $injector.invoke(['authenticationService', 'connectionErrorService', function (authenticationService, connectionErrorService) {
							if (authenticationService.isAuthenticated() && navigator.onLine) {
								return connectionErrorService.showServerErrorMsg(rejection);
							}
						}]);
					}
					break;
			}

			return newPromise || $q.reject(rejection);
		};

		return interceptor;

	});

});
